<?php
/*
#	Whatpulse API by Yaron Tal
#	http://www.bierkip.nl/node/4
#	
#	Free for all usage, but please keep at least my site and name in the file. 
#	If you like it, put a comment on my site :).
#	If you find any bugs or have any suggestions please also comment on my site.
#################################################
#	How to use this script:
#	Make a new php file or put the following code in your already existing php file.
#
	<?
		require('user_parse.php');
		$WP_stats = new WP_stats;
		$stats = $WP_stats->get(182042);
	?> 
#
#	Now you'll have an object called $stats with all the stats in it.
#
#
*/
class WP_stats {
	private $debug;
	private $mlog;
	private $errors;
	
	private $cachedir;
	private $cache_exist;
	
	//first get the cache dir
	function __construct() {
		$this->cachedir = dirname(__FILE__) . '/cache/';
	}
	
	//the logging function. Logs errors and msges for debug use
	function log($msg, $err=false) {
		if( $this->debug == true )
			$this->mlog['t'][] = htmlspecialchars($msg);
		if($err) $this->errors .= htmlspecialchars($msg) . '<br />';
	}
	
	//print the log made by the above function
	function printLog() {
		if( $this->errors )
			echo "<b>ERRORS:</b>\n $this->errors\n";
		
		if( $this->mlog ) {
			echo '<strong>Message Log</strong><ol>';
			foreach( $this->mlog as $type => $logSet ) {
				echo "<li>LOG[$type] (" .$this->timelog[$type]. "):<ol><li><pre>";
				echo implode("</pre></li><li><pre>", $logSet);
				echo '</pre></li></ol></li>';
			}
			echo '</ol>';
		}
		
	}
	
	//test if the cache dir exists and is writable
	function test() {
			
		if( is_writable( $this->cachedir ) && is_executable( $this->cachedir ) ) { 
			// simplest test -- can we write to the dir?
			$this->cache_exist = true;
		} else {
			// could not write. See if it even exists.
			if( file_exists($this->cachedir) ) { 
				// the folder is there, but isn't writeable. damn, try to make it so
				$dir = @chmod( $this->cachedir, 0777 );
				if($dir == false) { 
					// tried to chmod cache folder and failed.
					$this->log("Your cache directory (<code>" . $this->cachedir . "</code>) exists, but is not world writable (777). I couldn't make it so. Please do this by hand.",1);
					$this->cache_exist = false;
				} else {
					// yay, it was chmoded
					$this->cache_exist = true;
				}
			} else {
				//ack, no cache dir at all - try to make one with perms
				$dir = @mkdir( $this->cachedir, 0777);
				if($dir == false) { // tried to make cache folder and failed.
					$this->log("Your cache directory (<code>" . $this->cachedir . "</code>) needs to be created and world writable (777). I couldn't make it so. Please do this by hand.",1);
					$this->cache_exist = false;
				} else {
					// hey, we did it. Made the folder, and chmoded it
					$this->cache_exist = true;
				}
				
			} 
			
		}
		
		$this->log("Cache file testing/creation complete");
		return $this->cache_exist;
	}
	//check we already have a cache and if it's new enough to use it
	function test_cache($age = 1) {
		//no need to use this function twice if the file or folder doesn't exist or is not writable
		if ($this->cache_exist === true) {
			if ($age > 10) {
				//if we want a real old cashe file we better put it in the log. It might be an error
				$this->log("Trying old cache ($age hours old)");
			}
		
			if (file_exists($this->cachefile)) {
				$this->log("Cache file found");
				if (filemtime($this->cachefile) < (time() - (60* 60 * $age))) {
					$made = filemtime($this->cachefile);
					$made = date('Y-m-d H:i', $made);
					//log the creation time of the file if it's too old
					$this->log("Cache file too old (". $made .") ");
					return false;
				} else {
					return true;
				}
			} else {
				$this->cache_exist = false;
				$this->log("Cache file ( $this->cachefile ) doesn't exist");
				return false;
			}
		} 		
	}
	
	function fetch_new() {
		$this->log("Trying to get new stats from whatpulse.org");
		$link = 'http://whatpulse.org/api/user.php?UserID='. $this->uid;
		//get the stats with curl
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $link);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1) ;
		$this->cache = curl_exec($ch);
		$error = curl_error($ch);
		curl_close($ch);
		//if we have an error or if whatpulse doesn't know the user the attempt failed
		if ($error != '') {
			return false;
		} elseif ($this->cache == 'Unknow UserID given!') {
			$this->log('UserID '. $this->uid .' does not exist', 1);
			return false;
		} else {
			$this->fetch = 1;
			return true;
		}
	}
	//load the cache file 
	function get_cache() {
		$handle = fopen($this->cachefile, "r");
		$contents = fread($handle, filesize($this->cachefile));
		fclose($handle);
		$this->cache = $contents;
		$this->log("Cache file loaded");
		$this->fetch = 0;
	}
	//format and save the stats to the cache file
	function format_stats() {
		if ($this->fetch) { //no need to save the stats if they are loaded from the cache file
			if (!$handle = fopen($this->cachefile, 'w')) {
				$this->log("Cannot open file", 1);
			}
			if (fwrite($handle, $this->cache) === FALSE) {
				$this->log("Cannot write to file", 1);
			}
			$this->log("Cache file saved");
		}
		$this->cache = new SimpleXMLElement($this->cache);
	}
	
	//the function which should be called from the outside
	function get($uid, $debug = false) {
		$this->debug = $debug;
		empty($this->mlog['t']);
		$this->cachefile = $this->cachedir . md5($uid) .'.xml';
		//test the cache
		$this->test();
		$this->uid = (int) $uid; //we can only query one uid at a time, and it has to be a number
		
		if ($this->test_cache(6)) {	//if the cache exists and is new enough
			$this->get_cache();		//load the cache
			$this->format_stats();	//format and save them
			$this->printLog();		//print the log
			return $this->cache;	//and return the stats
		} elseif($this->fetch_new()) { 	//if that didn't work try to get new stats
			$this->format_stats();		//format and save those
			$this->printLog();			//print the log
			return $this->cache;		//and return the stats
		} elseif ($this->test_cache(1000)){ 	//and if even that didn't work get a real old version of the cache file
			$this->get_cache();					//which we load
			$this->format_stats();				//format and save
			$this->printLog();					//then we print the log
			return $this->cache;				//and we return the stats
		} else {
			$this->log("I don't know what to do now :(", 1); //if nothing worked
			$this->printLog();								//just return the logs
		}
	}

}
?>